//+------------------------------------------------------------------+
//|                                         Trix tape oscillator.mq4 |
//|                                                           mladen |
//+------------------------------------------------------------------+
#property copyright "mladen"
#property link      ""

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 DimGray
#property indicator_color2 Lime
#property indicator_minimum -1
#property indicator_maximum  1

//
//
//
//
//

extern int   TrixPeriod    = 14;
extern int   SignalPeriod  = 14;
extern int   SignalMethod  =  3;
extern int   BarsToCount   = 300;
extern bool  ShowTape      = true;
extern color TapeColorUp   = Green;
extern color TapeColorDown = Red;
extern int   TapeBarsWidth = 1;

//
//
//
//
//

double TrixBuffer[];
double TempBuffer[];
double SignBuffer[];
double EmaBuffer1[];
double EmaBuffer2[];
double EmaBuffer3[];
double MaxValue;
string shortName;
int    Window;
int    WindowID;
int    Correction;


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

int init()
{
   IndicatorBuffers(6);
   SetIndexBuffer(0,SignBuffer);
   SetIndexBuffer(1,TrixBuffer);
   SetIndexBuffer(2,EmaBuffer1);
   SetIndexBuffer(3,EmaBuffer2);
   SetIndexBuffer(4,EmaBuffer3);
   SetIndexBuffer(5,TempBuffer);
   
   //
   //
   //
   //
   //

   MaxValue     = 0.00;
   Correction   = 3*TrixPeriod+SignalPeriod;
   WindowID     = MathRand();
   BarsToCount  = MathMax(BarsToCount,300);
   shortName    = "Trix tape oscillator("+TrixPeriod+","+SignalPeriod+" : "+WindowID+")";
   
   //
   //
   //
   //
   //
   
   IndicatorShortName(shortName);
   IndicatorDigits(5);
   return(0);
}

int deinit()
{
   DeleteTape();
   return(0);
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

int start()
{
   double PrevMax = MaxValue;
   int    counted_bars=IndicatorCounted();
   int    limit,i;


   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit  = Bars-counted_bars;
         CheckWindow();

   //
   //
   //
   //
   //
      
   for (i=limit;i>=0;i--) EmaBuffer1[i] = iMA(NULL,0,TrixPeriod,0,MODE_EMA,PRICE_CLOSE,i);
   for (i=limit;i>=0;i--) EmaBuffer2[i] = iMAOnArray(EmaBuffer1,0,TrixPeriod,0,MODE_EMA,i);
   for (i=limit;i>=0;i--) {
         EmaBuffer3[i] = iMAOnArray(EmaBuffer2,0,TrixPeriod,0,MODE_EMA,i);

         //
         //
         //
         //
         //

         if (EmaBuffer3[i+1] != 0)
              TempBuffer[i] = (EmaBuffer3[i]-EmaBuffer3[i+1])/EmaBuffer3[i+1];
         else TempBuffer[i] = 0;
         if (i < BarsToCount+Correction)
            MaxValue = MathMax(MathAbs(TempBuffer[i]),MaxValue);
      }
   if (MaxValue != PrevMax)
         limit = (BarsToCount+Correction);
   else  limit = MathMin(Bars-counted_bars,BarsToCount+Correction);
   for (i=limit;i>=0;i--) TrixBuffer[i] = TempBuffer[i]/MaxValue;
   for (i=limit;i>=0;i--) SignBuffer[i] = iMAOnArray(TrixBuffer,0,SignalPeriod,0,SignalMethod,i);

   //
   //
   //
   //
   //

   DeleteTape();
   if (ShowTape) for (i=0; i<BarsToCount ;i++) DrawTape(TrixBuffer[i],SignBuffer[i],i);

   //
   //
   //
   //
   //
         
   for (i=0;i<indicator_buffers;i++) SetIndexDrawBegin(i,Bars-BarsToCount);
   return(0);
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

#define SignalName "TrixTape"
    int maxLines = 0;

//
//
//
//
//

void DrawTape(double __1, double __2,int shift)
{
   if (__1==__2) return;
   
   //
   //
   //
   //
   //
   
   maxLines++;
      datetime time = Time[shift];
      string   name = StringConcatenate(SignalName,WindowID,"-",maxLines);
 
      ObjectCreate(name,OBJ_TREND,Window,time,__1,time,__2);
         if (__1>__2)
               ObjectSet(name,OBJPROP_COLOR ,TapeColorUp);
         else  ObjectSet(name,OBJPROP_COLOR ,TapeColorDown);
         ObjectSet(name,OBJPROP_RAY   ,false);
         ObjectSet(name,OBJPROP_BACK  ,true);
         ObjectSet(name,OBJPROP_WIDTH ,TapeBarsWidth);
}
void DeleteTape()
{
   string name = StringConcatenate(SignalName,WindowID);
      while(maxLines>0) { ObjectDelete(StringConcatenate(name,"-",maxLines)); maxLines--; }
                          ObjectDelete(name);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

void CheckWindow()
{
   string name = StringConcatenate(SignalName,WindowID);
   
   //
   //
   //
   //
   //
   
   Window = WindowFind(shortName);
   if(Window == -1) {
      Window = ObjectFind(name);
      if(Window == -1) {
         Window = WindowOnDropped();
            ObjectCreate(name,OBJ_TEXT,Window,0,0);
      }
   }                     
}   

